from fastf1.livetiming.client import SignalRClient as sigR
import fastf1.livetiming.client as cli

import asyncio
import logging
import json
import zlib
import base64
import requests
import test_data
import time
import tkinter as tk
from PIL import Image, ImageTk, ImageDraw, ImageOps


def fix_json(elem):
        # fix F1's not json compliant data
        elem = elem.replace("'", '"') \
            .replace('True', 'true') \
            .replace('False', 'false')
        return elem

'''make recorded or live easier'''
def read_live(sigr):
    return sigr.message

def read_recorded(reader):
    return reader.next()




async def main():
    '''entry point to the main loop'''
    syms = {
            "1": "VER",
            "2": "SAR",
            "3": "RIC",
            "4": "NOR",
            "10":"GAS",
            "11":"PER",
            "14":"ALO",
            "16":"LEC",
            "18":"STR",
            "20":"MAG",
            "22":"TSU",
            "23":"ALB",
            "24":"ZHO",
            "27":"HUL",
            "31":"OCO",
            "33":"VER",
            "38":"BEA",
            "44":"HAM",
            "55":"SAI",
            "63":"RUS",
            "77":"BOT",
            "81":"PIA"
    }
    syms.setdefault("NON")

    colors = {
        # RBR
        "1":  "#3671C6",
        "11": "#3671C6",

        # williams
        "2":  "#64C4FF",
        "23": "#64C4FF",

        # VCARB
        "3":  "#6692FF",
        "22": "#6692FF",

        # mclaren
        "4":  "#FF8000",
        "81": "#FF8000",

        # alpine
        "10": "#FF87BC",
        "31": "#FF87BC",

        # aston martin
        "14": "#229971",
        "18": "#229971",

        # ferrari
        "16": "#E8002D",
        "55": "#E8002D",
        "38": "#E8002D",

        #haas
        "20": "#B6BABD",
        "27": "#B6BABD",

        # sauber
        "24": "#52E252",
        "77": "#52E252",

        # mercedes
        "44": "#27F4D2",
        "63": "#27F4D2",
    }
    colors.setdefault("#FFF")

    if not(RECORDED):
        # save live data to a file
        with open("dump.json", "w") as file:
            file.write("[")

    # one dictionary for the interval, one for the gap to leader. make this better
    timing_data={}
    storage={
            'high_x': 0,
            'low_x': 0,
            'high_y': 0,
            'low_y': 0,
            'lastfew': [],
            'lasttime': time.time(),
            'redraw': True,
            'im_last': 0,
            'frames_since_redraw': 0,
    }

    while True:
        if RECORDED:
            message = read_recorded(client)
        else:
            message = read_live(client)


        newest = fix_json(message) # get the most recent message
        

        # print timing data
        #print_table(timing_data, syms)
        #write_window(timing_data, syms, colors, window, storage)
        change_content(timing_data, syms, colors, window, storage) 

        # reading in the json
        if message != "nuh uh": #make sure its actual data
            if not(RECORDED):
                with open("monaco.json", 'a') as file: # log everything to a file
                    file.write(newest)
                    file.write(",\n")
                
            data=json.loads(newest) # load in the json

            try:
                for M in data['M']:
                    kind = M['A'][0] # what kin of data it is, full list in client.py/self.topics
                    # print(kind)

                    if kind == "TimingData":
                        parse_timingdata(timing_data, M) 
                    elif kind == "CarData.z":
                        parse_cardata(timing_data, M)
                    elif kind == "Position.z":
                        parse_position(timing_data, M)                
                        
                    elif kind == "TimingStats":
                        parse_timingstats(timing_data, M)


            except Exception as error:
                with open("errors.txt", 'a') as file:
                    file.write(f"error: {error}")
                    try:
                        file.write(data)
                    except:
                        pass
                    file.write("\n")

        if not(RECORDED):   
            await asyncio.sleep(0.01)


def parse_timingdata(data, message):
    info = message['A'][1]['Lines']
    drivers = info.keys()
    for driver in drivers:
        if not driver in data.keys(): # check that there is an entry for the driver that im looking at
            data[driver] = {}

        keys = info[driver].keys()

        if 'IntervalToPositionAhead' in keys: # if the data is for interval, do the thing
            data[driver]['ahead'] = float(info[driver]['IntervalToPositionAhead']['Value'])

        if 'GapToLeader' in keys:
            data[driver]['leader'] = float(info[driver]['GapToLeader'])

        if 'Sectors' in keys:
            temp = list(info[driver]['Sectors'].keys())[0]
            data[driver]['sector'] = int(temp)

        if 'Segments' in keys:
            data[driver]['segment'] = int(list(info[driver]['Sectors'][temp]['Segments'].keys())[0])
        
        if 'Speeds' in keys:
            data[driver]['speedt'] = float(info[driver]['Speeds']['ST']['Value'])



def parse_cardata(data, message):
    info = message['A'][1]
    inflated = zlib.decompress(base64.b64decode(info), -zlib.MAX_WBITS)
    cardata = json.loads(inflated)['Entries'][-1]['Cars']
    for driver in cardata.keys():
        if not driver in data.keys(): # check that there is an entry for the driver that im looking at. amke one if not
            data[driver] = {}
        
        data[driver]['speed'] = cardata[driver]['Channels']['2']
        data[driver]['RPM'] = cardata[driver]['Channels']['0']


def parse_timingstats(data, message):
    info = message['A'][1]['Lines']
    for driver in info.keys():
        if 'PersonalBestLapTime' in info[driver].keys():
            data[driver]['pos'] = info[driver]['PersonalBestLapTime']['Position']
            try:
                data[driver]['time'] = info[driver]['PersonalBestLapTime']['Value']
            except:
                pass

def parse_position(data, message):
    info = message['A'][1]
    inflated = zlib.decompress(base64.b64decode(info), -zlib.MAX_WBITS)
    positions = json.loads(inflated)['Position'][-1]['Entries']
    for driver in positions.keys():
        if not driver in data.keys(): # check that there is an entry for the driver that im looking at
            data[driver] = {}
        data[driver]['status'] = positions[driver]['Status']
        data[driver]['x'] = positions[driver]['X']
        data[driver]['y'] = positions[driver]['Y']
        data[driver]['z'] = positions[driver]['Z']


def sort(data):
    distances = {}
    '''
    try:
        for driver in data.keys():
            try:
                distance = data[driver]['sector']*0.33 + data[driver]['segment']*0.03
            except:
                distance = 1

            distances[driver] = distance
            if 'distance' not in data[driver].keys():
                data[driver]['distance'] = -1


            if data[driver]['distance'] == distance:
                data[driver]['time_at_distance'] += 1
            else:
                data[driver]['distance'] = distance
                data[driver]['time_at_distance'] = 0
    except:
        return list(data.keys())
    '''
    drivers_list = list(data.keys())
    if len(drivers_list) < 1:
        return data.keys()

    order = [drivers_list[0]]

    for i in range(1,len(drivers_list)):
        # get rid of stopped drivers
        try:
            if data[drivers_list[i]]['speed'] == 0:
                continue
        except:
            continue


        for j in range(len(order)):
            if 'leader' not in data[drivers_list[i]].keys():
                # for investigated driver, if the gap to the leader isnt known, assume theyre first
                order.insert(0, drivers_list[i])
                break

            if 'leader' not in data[order[j]].keys():
                # skip where interval not known for comparison
                continue
                

            if data[drivers_list[i]]['leader'] < data[order[j]]['leader']:
                # if the driver under investigation is closer to the front than the driver in comparison, that is the place to be
                order.insert(j, drivers_list[i])
                break
        if drivers_list[i] not in order:
            order.append(drivers_list[i])
    return order

def init_content(tkwin):

    fram = tk.Frame(tkwin, name="timing")
    fram.grid(row=0, column=0)

    headings = ["name", "speed", "gap to leader", "interval"]

    for i in range(len(headings)):
        tk.Label(fram, text=headings[i], name=f"heading_{headings[i]}").grid(row=0, column=i, padx={20, 20})

    for pos in range(20):
        for head in range(len(headings)):  
            tk.Label(fram, text=f"initted", name=f"p{pos}_{headings[head]}").grid(row = pos + 1, column = head)

    canv = tk.Canvas(height=400, width=400, name = "track_map")
    canv.grid(row=0, column=1)

    button_frame = tk.Frame(tkwin, name="buttons")
    button_frame.grid(row=1, column=1)
    tk.Button(button_frame, text="overtake", name="otbutton").grid(row=0, column=0)
    tkwin.update()


def change_content(data, syms, colors, tkwin, persistent):
    order = sort(data)
    headings = ["name", "speed", "gap to leader", "interval"]
    texts = [
                "data[driver_num]['speed']",
                "data[driver_num]['leader']",
                "data[driver_num]['ahead']",
        ]
    labels = {}
    for head in headings:
        labels[f"heading_{head}"] = head

    def otbutton():
        data[order[1]]['leader'] = 0

    for order_idx in range(len(order)):
        # store the driver number along with the position theyre in to make adding colour possible
        # little bit hacky so the string is always the same length. will be a problem if there are ever 100 drivers on the grid
        if order_idx < 10:
            labels[f"p{order_idx}__num"] = order[order_idx]
        else:
            labels[f"p{order_idx}_num"] = order[order_idx]
        
        # for each heading on the table, get the data and store it to be drawn
        for heading_idx in range(len(headings)):
            # driver name is a special case, so handle it in a spcial way
            if headings[heading_idx] == "name":
                labels[f"p{order_idx}_{headings[heading_idx]}"] = syms[order[order_idx]]
                continue
            driver_num = order[order_idx] # this is necessary for the eval below, see texts array  around line 320 for its use
            try:
                labels[f"p{order_idx}_{headings[heading_idx]}"] = eval(f"{texts[heading_idx-1]}")
            except:
                labels[f"p{order_idx}_{headings[heading_idx]}"] = "idk"


    for frame in tkwin.winfo_children():
        # checks the top level thingies (timing table, track map)
        if frame._name == "timing":
            # iterate over each label, update the content to what is true now
            # labels dictionary has the keys to be the id of the label, which  looks a bit ugly but works nicely
            for child in frame.winfo_children():
                try:
                    col_name = f"{child._name[0:3]}_num"
                    color = colors.get(labels[col_name], "#FFFFFF")
                    child.config(text = labels[child._name], background=color)
                except:
                    pass
        
        elif frame._name == "track_map":
            frame.destroy()
            for driver_num in order:
                try: 
                    x = data[driver_num]['x']
                    y = data[driver_num]['y']
                except Exception as e:
                    continue

                if x > persistent['high_x']:
                    persistent['high_x'] = x
                    persistent['redraw'] = True
                elif x < persistent['low_x']:
                    persistent['low_x'] = x
                    persistent['redraw'] = True

                if y > persistent['high_y']:
                    persistent['high_y'] = y
                    persistent['redraw'] = True
                elif y < persistent['low_y']:
                    persistent['low_y'] = y
                    persistent['redraw'] = True

                persistent['lastfew'] += [(x, y)]

            canv_height = 400
            canv_width = 400
            canvas = tk.Canvas(tkwin, height=canv_height, width=canv_width, bg = "pink", name = "track_map")
            im = draw_track(canv_height, canv_width, data, persistent, colors)
            im.save("track.png")
            img = ImageTk.PhotoImage(image=im)
            canvas.create_image(3+canv_width/2, 3+canv_height/2, image=img, anchor="center")
            canvas.grid(row=0, column=1)
        
        elif frame._name == "buttons":
            for child in frame.winfo_children():
                if child._name == "otbutton":
                    print("got the right button")
                    child.config(command=otbutton)

    tkwin.update()

def write_window(data, syms, colors, tkwin, persistent):
    for child in tkwin.winfo_children():
        try:
            print(f"{child}: {child['text']}")
            child.destroy()
        except:
            pass


    order = sort(data)
    fram = tk.Frame(tkwin, name="hiii")
    fram.grid(row=0, column=0)

    headings = ["name", "speed", "gap to leader", "interval"]

    for i in range(len(headings)):
        tk.Label(fram, text=headings[i]).grid(row=0, column=i, padx={20, 20})

    for i in range(len(order)):
        driver_num = order[i]
        
        color = colors.get(driver_num, "#FFFFFF")

        texts = [
                "data[driver_num]['speed']",
                "data[driver_num]['leader']",
                "data[driver_num]['ahead']",
        ]
        
        try:
            tk.Label(fram, text = syms[driver_num], background=(color)).grid(row = i+1, column = 0)
        except:
            pass
            

        for j in range(len(texts)):
            try:
                tk.Label(fram, text = eval(f"{texts[j]}"), background = (color)).grid(row = i+1, column = j+1)
            except Exception as error:
                tk.Label(fram, text = "idk", background=(color)).grid(row=i+1, column=j+1)

    canv_height = 400 
    canv_width = 400
    canvas = tk.Canvas(tkwin, height=canv_height, width=canv_width, bg = "pink")
 
   
    for driver_num in order:
        try: 
            x = data[driver_num]['x']
            y = data[driver_num]['y']
        except Exception as e:
            continue

        if x > persistent['high_x']:
            persistent['high_x'] = x
            persistent['redraw'] = True
        elif x < persistent['low_x']:
            persistent['low_x'] = x
            persistent['redraw'] = True

        if y > persistent['high_y']:
            persistent['high_y'] = y
            persistent['redraw'] = True
        elif y < persistent['low_y']:
            persistent['low_y'] = y
            persistent['redraw'] = True

        persistent['lastfew'] += [(x, y)]


    im = draw_track(canv_height, canv_width, data, persistent, colors)
    img = ImageTk.PhotoImage(image=im)

    canvas.create_image(3+canv_width/2, 3+canv_height/2, image=img, anchor="center")

    def le():
        print("num_p1")

    canvas.grid(row=0, column=1)
    tk.Button(tkwin, text="swap first and second", command=le).grid(row=2,column=1)

    now = time.time()
    dt = now-persistent['lasttime']
    tk.Label(tkwin, text = f"{1/(dt):.2f}").grid(row=1, column=1)
    if RECORDED:
        tk.Label(tkwin, text = client.index).grid(row=1, column=2)
    persistent['lasttime'] = now


    time.sleep(1e-3)
    tkwin.update()


def draw_track(height, width, data, persistent, colors):
    scale_x = (persistent['high_x'] - persistent['low_x']) / width
    scale_y = (persistent['high_y'] - persistent['low_y']) / height

    scale=max(scale_x, scale_y)

    offset_x = 0 
    offset_y = 0


    if scale_y > scale_x:
        offset_x = int(width * scale_x/scale_y)
    if scale_y < scale_x:
        offset_y = int(height * scale_y/scale_x)
    offset_y = 0 
    offset_x = 0


    if True:
        persistent['frames_since_redraw'] = 0
        im = Image.new("RGB", (width, height))

        for point in persistent['lastfew']:
            # draw the history of the race as white dots
            x = point[0]
            y = point[1]

            x_adj = int((x - persistent['low_x'])/scale)-1
            y_adj = int((y - persistent['low_y'])/scale)-1

            try:
                im.putpixel([x_adj+offset_x, y_adj+offset_y], (255, 255, 255))
            except:
                pass

        for driver_num in data.keys():
            try:
                # try and get the position of the driver. if not, fuhgettabatit
                x = data[driver_num]['x']
                y = data[driver_num]['y']

            except:
                continue

            try:
                # try and scale it to fit on the screen
                x_adj = int((x - persistent['low_x'])/scale)-1
                y_adj = int((y - persistent['low_y'])/scale)-1
            except:
                continue

            col_tup = tuple(int(colors.get(driver_num, "#FFFFFF")[i:i+2], 16) for i in (1, 3, 5))

            r=2

            #make it more visible
            for i in range(-r, r):
                for j in range(-r, r):
                    try:
                        im.putpixel([x_adj+offset_x+i, y_adj+offset_y+j], col_tup)
                    except:
                        pass

    while len(persistent['lastfew']) > 100000:
        del persistent['lastfew'][0]

    persistent['redraw'] = persistent['frames_since_redraw'] > 300

    #im2 = im.copy()

    #im_bw = im2.convert("1").convert('RGB')
    #persistent['im_last'] = im_bw

    return im


def print_table(data, syms):
    
    print("\033[2Jnumber\tint\tleader\tsector\tspeedtrap\tspeed\tfastest pos\ttrack pos") # print the head to the tables
    print()
    order = sort(data)
    
    try:
        for key in order:
            if key in syms.keys():
                print(f"{syms[key]}\t", end="")
            else:
                print(f"{key}\t", end = "")

            try:
                print(f"{data[key]['ahead']}\t", end="")
            except:
                print("\t", end="")

            try:
                print(f"{data[key]['leader']}\t", end="")
            except:
                print("\t", end="")
            
            try:
                print(f"{data[key]['sector']}/{data[key]['segment']}\t", end="")
            except:
                print("\t", end="")

            try:
                print(f"{data[key]['speedt']}\t\t", end="")
            except:
                print("\t\t", end="")

            try:
                print(f"{data[key]['speed']}\t", end="")
            except:
                print("\t", end="")

            try:
                print(f"\t{data[key]['pos']}\t", end="")
            except:
                print("\t\t", end="")

            try:
                print(f"{data[key]['x']},{data[key]['y']}\t", end = "")
            except:
                print("\t", end = "")
            
            try:
                print(f"{data[key]['time']}", end = "")
            except:
                print("\t", end = "")

            print()



    except Exception as e:
        if len(data.keys()) > 5:
            raise e
        pass

# switch for testing or prod
RECORDED = True

if RECORDED:
    client = test_data.dataSender("imola.json", 10000)
else:
    client = sigR(filename="cache.txt", debug=True)

window=tk.Tk()
window.option_add("*Font", "monaco")

init_content(window)

if RECORDED:
    asyncio.run(main())
else:
    asyncio.run(client._async_start(main()))

